﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace ZPLDemo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            int result = 0;
            int status = 0;
            zpl_dll dll = new zpl_dll();

           

           // 创建一个打印机
            result = zpl_dll.PrinterCreator(ref dll.printer, "iX4P3");

            if (0 == result)
            {
                if ((result = zpl_dll.PortOpen(dll.printer, "USB")) == 0)
                {
                    //byte[] strFonts = new byte[128];
                    //result = zpl_dll.ZPL_GetPrinterFonts(dll.printer, strFonts);
                    //string strXX=Encoding.ASCII.GetString(strFonts);
                    //MessageBox.Show(strXX.ToString());

                    //获取打印机状态
                    result = zpl_dll.ZPL_GetPrinterStatus(dll.printer, ref status);
                    //开始
                    result = zpl_dll.ZPL_StartFormat(dll.printer);

                    //result = zpl_dll.ZPL_SetPrinterNetMode(dll.printer, 2);
                    //result = zpl_dll.ZPL_SetPrinterNetSSID(dll.printer, 2, "HM-T300 Pro");
                    //result = zpl_dll.ZPL_SetPrinterNetPwdSwitch(dll.printer, 1);
                    //result = zpl_dll.ZPL_SetPrinterNetPwd(dll.printer, 2, "12345678");
                    //result = zpl_dll.ZPL_SetPrinterNetDHCP(dll.printer, 1);
                    //result = zpl_dll.ZPL_SetPrintIpAddress(dll.printer, 2, "192.168.1.2");
                    //result = zpl_dll.ZPL_SetPrintSubnetMask(dll.printer, "255.255.255.1");
                    //result = zpl_dll.ZPL_SetPrintDefaultGateway(dll.printer, "192.168.1.2");
                    //result = zpl_dll.ZPL_SetPrinterBluetoothSSID(dll.printer, "Bluetooth SSID");
                    //result = zpl_dll.ZPL_SetPrinterBluetoothPIN(dll.printer, "12345678");
                    //result = zpl_dll.ZPL_SetPrinterSleepTime(dll.printer, 5);
                    //result = zpl_dll.ZPL_SetPrinterShutdownTime(dll.printer, 360);

                    //读取版本号
                    byte[] strVersion = new byte[128];
                    result = zpl_dll.ZPL_GetPrinterFirmwareVersion(dll.printer, strVersion);

                    //获取打印机内置字体
                    byte[] strFonts = new byte[128];
                    result = zpl_dll.ZPL_GetPrinterFonts(dll.printer, strFonts);
           
                    //设置打印浓度
                    result = zpl_dll.ZPL_SetPrintDarkness(dll.printer, 20);

                    //设置是否翻转打印
                    result = zpl_dll.ZPL_SetPrintOrientation(dll.printer, 0);

                    //打印图片
                    result = zpl_dll.ZPL_PrintImage(dll.printer, 100, 30, "D:\\1.bmp");

                    //打印Pdf417
                    result = zpl_dll.ZPL_Pdf417(dll.printer, 100, 180, 0, 2, 20, 2, 5, 5, 'N', "0010101101");

                    //打印BarCode39条码
                    result = zpl_dll.ZPL_BarCode39(dll.printer, 100, 300, 0, 3, 50, 'Y', 'Y', 'Y', "66886868");

                    //打印CodeEan8条码
                    result = zpl_dll.ZPL_CodeEan8(dll.printer, 100, 400, 0, 3, 60, 'Y', 'Y', "90381010");

                    //打印UPC-E
                    result = zpl_dll.ZPL_UpceCode(dll.printer, 100, 500, 0, 3, 50, 'N', 'N', "001100");

                    //打印UPC-A
                    result = zpl_dll.ZPL_UpcaBarcode(dll.printer, 100, 600, 0, 3, 50, 'Y', 'Y', 'N', "47631664454");

                    //打印UPC扩展条码
                    result = zpl_dll.ZPL_UpcExtensions(dll.printer, 100, 700, 0, 3, 50, 'Y', 'Y', "01234");

                    //打印二维码
                    result = zpl_dll.ZPL_QRCode(dll.printer, 100, 800, 0, 1, 3, 'M', 'M', 'N', "1000000001");

                    //打印汉字 
                    result = zpl_dll.ZPL_SetChangeFontEncoding(dll.printer, 14);
                    result = zpl_dll.ZPL_Text(dll.printer, 100, 900, 16, 0, 40, 40, "你好");
                    result = zpl_dll.ZPL_Text(dll.printer, 300, 900, 16, 0, 40, 40, "hello");
                    result = zpl_dll.ZPL_Text(dll.printer, 500, 900, 16, 0, 40, 40, "こんにちは");

                    //打印图形圆圈
                    result = zpl_dll.ZPL_GraphicCircle(dll.printer, 100, 1000, 150, 5);

                    //打印图形椭圆
                    result = zpl_dll.ZPL_GraphicEllipse(dll.printer, 300, 1000, 150, 100, 10);

                    //打印对角线
                    result = zpl_dll.ZPL_GraphicDiagonalLine(dll.printer, 500, 1000, 0x52, 50, 50, 20);

                    //打印图形框
                    result = zpl_dll.ZPL_GraphicBox(dll.printer, 100, 1200, 100, 100, 60, 3);

                    //打印符号
                    result = zpl_dll.ZPL_GraphicSymbol(dll.printer, 300, 1200, 0, 200, 200, "A");

                    //DirectIO 使用示例
                    //byte[] str = new byte[] { 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x20 };
                    //result = zpl_dll.DirectIO(dll.printer, str, 10, str, 0, ref result);

                    //RFID读写
                    //result = zpl_dll.ZPL_RfidCalibration(dll.printer);
                    //result = zpl_dll.ZPL_RfidWrite(dll.printer, 'H', 2, 4, 'A', "12345678");
                    //result = zpl_dll.ZPL_RfidRead(dll.printer, 'H', 2, 4, 'A', "", "");

                    //RFID读取空白接口
                    //result = zpl_dll.ZPL_RfidReadEmpty(dll.printer);

                    //ZPL切刀
                    result = zpl_dll.ZPL_SetPrintMode(dll.printer, 'C', 'Y');
                    result = zpl_dll.ZPL_Cutter(dll.printer, 0);
                    result = zpl_dll.ZPL_SetPrintQuantity(dll.printer, 1, 1, 1, 'Y');

                    //结束
                    result = zpl_dll.ZPL_EndFormat(dll.printer);

                    //byte[] strrfid = new byte[8];
                    //result = zpl_dll.ReadData(dll.printer, strrfid, 8, ref preadedNum);

                    //删除打印机
                    result = zpl_dll.PortClose(dll.printer);

                    //销毁
                    result = zpl_dll.PrinterDestroy(dll.printer);
                }
                else
                {
                    MessageBox.Show("Usb Device not found.please confirm the target printer is connected and power on.");
                }

            }

            // result = zpl_dll.ZPL_FontDownload(dll.printer, "D:\\T300PRO_font_V1.1.1.prtf", "HM-T300 PRO", "USB");
            // result = zpl_dll.ZPL_VectorFontDownload(dll.printer, "D:\\LCALLIG.TTF", "HM-T300 PRO", "USB");
            // result = zpl_dll.ZPL_FirmwareUpgrade(dll.printer, "D:\\HM-T300PRO_V1.1.24_00_Beta4.bin", "HM-T300 PRO", "USB");
            // RFIDTEXT_HL();
            // RFIDTEXT_HR();
            // RFIDTEXT_RB();
            // RFIDTEXT_RR();
            // RFIDTEXT_RS();
            // RFIDTEXT_RW();
            // RFIDTEXT_RZ();
            // RFIDTEXT_RU();
        }

        private void RFIDTEXT_HL()
        {
            int result = 0;
            zpl_dll dll = new zpl_dll();

            //创建一个打印机 
            result = zpl_dll.PrinterCreator(ref dll.printer, "HT300");

            if (0 == result)
            {
                if ((result = zpl_dll.PortOpen(dll.printer, "USB")) == 0)
                {
                    //开始
                    result = zpl_dll.ZPL_StartFormat(dll.printer);

                    result = zpl_dll.ZPL_RfidReturnHostDatalog(dll.printer);

                    //结束
                    result = zpl_dll.ZPL_EndFormat(dll.printer);

                    //删除打印机
                    result = zpl_dll.PortClose(dll.printer);

                    //销毁
                    result = zpl_dll.PrinterDestroy(dll.printer);
                }
                else
                {
                    MessageBox.Show("Usb Device not found.please confirm the target printer is connected and power on.");
                }
            }
            else
            {
                MessageBox.Show("Printer Device not found.");
            }
        }

        private void RFIDTEXT_HR()
        {
            int result = 0;
            string pStartStr = "start";
            string pEndStr = "end";
            string pStartPosition = "B20";
            string pEndPosition = "F42";
            char model = 'M';
            zpl_dll dll = new zpl_dll();

            //创建一个打印机 
            result = zpl_dll.PrinterCreator(ref dll.printer, "HT300");

            if (0 == result)
            {
                if ((result = zpl_dll.PortOpen(dll.printer, "USB")) == 0)
                {
                    //开始
                    result = zpl_dll.ZPL_StartFormat(dll.printer);

                    result = zpl_dll.ZPL_RfidCorrectXpdnrPosition(dll.printer, pStartStr.ToCharArray(), pEndStr.ToCharArray(), pStartPosition.ToCharArray(), pEndPosition.ToCharArray(), model);

                    //结束
                    result = zpl_dll.ZPL_EndFormat(dll.printer);

                    //删除打印机
                    result = zpl_dll.PortClose(dll.printer);

                    //销毁
                    result = zpl_dll.PrinterDestroy(dll.printer);
                }
                else
                {
                    MessageBox.Show("Usb Device not found.please confirm the target printer is connected and power on.");
                }
            }
            else
            {
                MessageBox.Show("Printer Device not found.");
            }
        }

        private void RFIDTEXT_RB()
        {
            int result = 0;
            zpl_dll dll = new zpl_dll();
            int nTotalNum = 96;
            int[] pPartitionSize = { 8, 3, 3, 20, 24, 38 };
            //创建一个打印机 
            result = zpl_dll.PrinterCreator(ref dll.printer, "HT300");

            if (0 == result)
            {
                if ((result = zpl_dll.PortOpen(dll.printer, "USB")) == 0)
                {
                    //开始
                    result = zpl_dll.ZPL_StartFormat(dll.printer);

                    result = zpl_dll.ZPL_RfidDefineDataStruct(dll.printer, nTotalNum, pPartitionSize, pPartitionSize.Length);

                    string strText = "48,1,6,770289,10001025,1";
                    result = zpl_dll.ZPL_RfidWrite(dll.printer, 'E', 0, 1, 'E', strText.ToCharArray());

                    //结束
                    result = zpl_dll.ZPL_EndFormat(dll.printer);

                    //删除打印机
                    result = zpl_dll.PortClose(dll.printer);

                    //销毁
                    result = zpl_dll.PrinterDestroy(dll.printer);
                }
                else
                {
                    MessageBox.Show("Usb Device not found.please confirm the target printer is connected and power on.");
                }
            }
            else
            {
                MessageBox.Show("Printer Device not found.");
            }
        }

        private void RFIDTEXT_RR()
        {
            int result = 0;
            int nRetryCount = 2;
            zpl_dll dll = new zpl_dll();

            //创建一个打印机 
            result = zpl_dll.PrinterCreator(ref dll.printer, "HT300");

            if (0 == result)
            {
                if ((result = zpl_dll.PortOpen(dll.printer, "USB")) == 0)
                {
                    //开始
                    result = zpl_dll.ZPL_StartFormat(dll.printer);

                    result = zpl_dll.ZPL_RfidRetryCount(dll.printer, nRetryCount);

                    string strText = "1234";

                    result = zpl_dll.ZPL_RfidWrite(dll.printer, 'H', 0, 1, 'E', strText.ToCharArray());

                    //结束
                    result = zpl_dll.ZPL_EndFormat(dll.printer);

                    //删除打印机
                    result = zpl_dll.PortClose(dll.printer);

                    //销毁
                    result = zpl_dll.PrinterDestroy(dll.printer);
                }
                else
                {
                    MessageBox.Show("Usb Device not found.please confirm the target printer is connected and power on.");
                }
            }
            else
            {
                MessageBox.Show("Printer Device not found.");
            }
        }

        private void RFIDTEXT_RS()
        {
            int result = 0;
            zpl_dll dll = new zpl_dll();
            int nTagNum = 2;
            int nErrorAct = 'P';

            //创建一个打印机 
            result = zpl_dll.PrinterCreator(ref dll.printer, "HT300");

            if (0 == result)
            {
                if ((result = zpl_dll.PortOpen(dll.printer, "USB")) == 0)
                {
                    //开始
                    result = zpl_dll.ZPL_StartFormat(dll.printer);

                    result = zpl_dll.ZPL_RfidSetParameters(dll.printer, nTagNum, nErrorAct);

                    //结束
                    result = zpl_dll.ZPL_EndFormat(dll.printer);

                    //删除打印机
                    result = zpl_dll.PortClose(dll.printer);

                    //销毁
                    result = zpl_dll.PrinterDestroy(dll.printer);
                }
                else
                {
                    MessageBox.Show("Usb Device not found.please confirm the target printer is connected and power on.");
                }
            }
            else
            {
                MessageBox.Show("Printer Device not found.");
            }
        }

        private void RFIDTEXT_RW()
        {
            int result = 0;
            int nReadPower = 'H';
            int nWritePower = 'H';
            int nAntennaType = 1;
            zpl_dll dll = new zpl_dll();

            //创建一个打印机 
            result = zpl_dll.PrinterCreator(ref dll.printer, "HT300");

            if (0 == result)
            {
                if ((result = zpl_dll.PortOpen(dll.printer, "USB")) == 0)
                {
                    //开始
                    //result = zpl_dll.ZPL_StartFormat(dll.printer);

                    result = zpl_dll.ZPL_RfidSetPowerLevel(dll.printer, nReadPower, nWritePower, nAntennaType);

                    //结束
                    //result = zpl_dll.ZPL_EndFormat(dll.printer);

                    //删除打印机
                    result = zpl_dll.PortClose(dll.printer);

                    //销毁
                    result = zpl_dll.PrinterDestroy(dll.printer);
                }
                else
                {
                    MessageBox.Show("Usb Device not found.please confirm the target printer is connected and power on.");
                }
            }
            else
            {
                MessageBox.Show("Printer Device not found.");
            }
        }

        private void RFIDTEXT_RZ()
        {
            int result = 0;
            string strPassword = "1234ABCD";
            string strText = "112233445566778899001122";
            int nMemoryBlock = 'E';
            char locktype = 'L';
            zpl_dll dll = new zpl_dll();

            //创建一个打印机 
            result = zpl_dll.PrinterCreator(ref dll.printer, "HT300");

            if (0 == result)
            {
                if ((result = zpl_dll.PortOpen(dll.printer, "USB")) == 0)
                {
                    //开始
                    result = zpl_dll.ZPL_StartFormat(dll.printer);

                    result = zpl_dll.ZPL_RfidWrite(dll.printer, 'H', 0, 1, 'E', strText.ToCharArray());

                    result = zpl_dll.ZPL_RfidSetLockTagAndPassword(dll.printer, strPassword.ToCharArray(), nMemoryBlock, locktype);

                    //结束
                    result = zpl_dll.ZPL_EndFormat(dll.printer);

                    //删除打印机
                    result = zpl_dll.PortClose(dll.printer);

                    //销毁
                    result = zpl_dll.PrinterDestroy(dll.printer);
                }
                else
                {
                    MessageBox.Show("Usb Device not found.please confirm the target printer is connected and power on.");
                }
            }
            else
            {
                MessageBox.Show("Printer Device not found.");
            }
        }

        private void RFIDTEXT_RU()
        {
            int result = 0;
            zpl_dll dll = new zpl_dll();
            string strSerial = "Serial Number: #H";
            string strText = "12#H";

            //创建一个打印机 
            result = zpl_dll.PrinterCreator(ref dll.printer, "HT300");

            if (0 == result)
            {
                if ((result = zpl_dll.PortOpen(dll.printer, "USB")) == 0)
                {
                    //开始
                    result = zpl_dll.ZPL_StartFormat(dll.printer);

                    result = zpl_dll.ZPL_RfidReadChipSerialization(dll.printer);

                    result = zpl_dll.ZPL_ScalableFontText(dll.printer, 10, 10, '0', 'N', 50, 50, strSerial.ToCharArray());

                    result = zpl_dll.ZPL_RfidWrite(dll.printer, 'H', 0, 1, 'E', strText.ToCharArray());

                    //结束
                    result = zpl_dll.ZPL_EndFormat(dll.printer);

                    //删除打印机
                    result = zpl_dll.PortClose(dll.printer);

                    //销毁
                    result = zpl_dll.PrinterDestroy(dll.printer);
                }
                else
                {
                    MessageBox.Show("Usb Device not found.please confirm the target printer is connected and power on.");
                }
            }
            else
            {
                MessageBox.Show("Printer Device not found.");
            }
        }

        public void CallBackfun()
        { }
    }
    public class zpl_dll
    {
        public const CharSet charSet = CharSet.Ansi;
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int PrinterCreator(ref IntPtr printer, string model);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int PrinterCreatorS(string model);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int PrinterDestroy(IntPtr printer);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int PortOpen(IntPtr printer, string portSetting);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int PortClose(IntPtr printer);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int WriteData(IntPtr printer, byte[] writeData, int writeNum);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ReadData(IntPtr printer, byte[] readData, int readNum, ref int preadedNum);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int DirectIO(IntPtr printer, byte[] writeData, int writeNum, byte[] readData, int readNum, ref int preadedNum);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_StartFormat(IntPtr printer);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_EndFormat(IntPtr printer);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetChangeFontEncoding(IntPtr printer, int encodeType);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_Text(IntPtr printer, int xPos, int yPos, int fontNum, int orientation, int fontWidth, int fontHeight, string text);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_Text_Block(IntPtr printer, int xPos, int yPos, int fontNum, int orientation, int fontWidth, int fontHeight, int textblockWidth, int textblockHeight, string text);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_BarCode39(IntPtr printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, string text);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_Pdf417(IntPtr printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, int securityLevel, int column, int rows, char truncate, string text);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_CodeEan8(IntPtr printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, string text);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_UpceCode(IntPtr printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, string text);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_QRCode(IntPtr printer, int xPos, int yPos, int orientation, int model, int dpi, char errLevel, char input, char charMode, string text);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_UpcExtensions(IntPtr printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, string text);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_UpcaBarcode(IntPtr printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, string text);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetChangeCaret(IntPtr printer, char charactor);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetChangeDelimiter(IntPtr printer, char charactor);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetChangeTilde(IntPtr printer, char charactor);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_GraphicBox(IntPtr printer, int xPos, int yPos, int width, int height, int thickness, int rounding);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_GraphicCircle(IntPtr printer, int xPos, int yPos, int diameter, int thickness);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_GraphicDiagonalLine(IntPtr printer, int xPos, int yPos, int orientation, int width, int height, int thickness);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_GraphicEllipse(IntPtr printer, int xPos, int yPos, int width, int height, int thickness);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_PrintImage(IntPtr printer, int xPos, int yPos, string imgName);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_GraphicSymbol(IntPtr printer, int xPos, int yPos, int orientation, int width, int height, string type);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetDiagnosticsMode(IntPtr printer, int isEnable);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrintOrientation(IntPtr printer, int orientation);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrintRate(IntPtr printer, int printSpeed, int slewSpeed, int backfeedSpeed);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrintDarkness(IntPtr printer, int darkness);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_PrintConfigurationLabel(IntPtr printer);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_GetPrinterStatus(IntPtr printer, ref int status);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrintMode(IntPtr printer, char mode, char prePeelSelect);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrintQuantity(IntPtr printer, int totalQuantity, int pauseAndCutValue, int replicatesOfEachSerialNumber, char overridePauseCount );
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrintWidth(IntPtr printer, int width);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_FirmwareUpgrade(IntPtr printer, string FileName, string model, string ioSettings);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_FontDownload(IntPtr printer, string FileName, string model, string ioSettings);
        [DllImport("ZPL_SDK", CharSet = charSet)]
         public static extern int ZPL_VectorFontDownload(IntPtr printer, string FileName, string model, string ioSettings);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_GetPrinterFonts(IntPtr printer, byte[] fonts);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrinterInstruction(IntPtr printer, int type);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrinterNetMode(IntPtr printer, int mode);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrinterNetSSID(IntPtr printer, int mode, string ssid);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrinterNetPwd(IntPtr printer, int mode, string pwd);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrinterNetPwdSwitch(IntPtr printer, int mode);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrinterNetDHCP(IntPtr printer, int mode);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrintIpAddress(IntPtr printer, int mode, string ipaddress);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrintSubnetMask(IntPtr printer, string mask);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrintDefaultGateway(IntPtr printer, string gateway);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrinterBluetoothSSID(IntPtr printer, string ssid);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrinterBluetoothPIN(IntPtr printer, string pin);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrinterSleepTime(IntPtr printer, int time);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_SetPrinterShutdownTime(IntPtr printer, int time);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_HostStatusReturn(IntPtr printer, byte[] status);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidWrite(IntPtr printer, char format, int begin, int size, char memoryBlock, string text);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidRead(IntPtr printer, char format, int begin, int size, char memoryBlock, string headText, string tailText);
        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidCalibration(IntPtr printer);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidWrite(IntPtr printer, char format, int begin, int size, char memoryBlock, char[] text);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_ScalableFontText(IntPtr printer, int xPos, int yPos, char fontName, int orientation, int fontWidth, int fontHeight, char[] text);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidReturnHostDatalog(IntPtr printer);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidCorrectXpdnrPosition(IntPtr printer, char[] pStartStr, char[] pEndStr, char[] pStartPosition, char[] pEndPosition, char model);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidDefineDataStruct(IntPtr printer, int nTotalNum, int[] pPartitionSize, int nPartitionLenth);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidRetryCount(IntPtr printer, int nRetryCount);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidSetParameters(IntPtr printer, int nTagNum, int nErrorAct);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidSetPowerLevel(IntPtr printer, int nReadPower, int nWritePower, int nAntennaType);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidSetLockTagAndPassword(IntPtr printer, char[] password, int nMemoryBlock, char locktype);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidReadChipSerialization(IntPtr printer);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_RfidReadEmpty(IntPtr printer);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_Cutter(IntPtr printer,int partialCutReserveDistance);

        [DllImport("ZPL_SDK", CharSet = charSet)]
        public static extern int ZPL_GetPrinterFirmwareVersion(IntPtr printer, byte[] version);

        public IntPtr printer;
    }
}